/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.circles;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Contract;

public interface ICircleComponent {
    public ControlFlow acceptControlFlow(CastingImage var1, CircleCastEnv var2, class_2350 var3, class_2338 var4, class_2680 var5, class_3218 var6);

    @Contract(pure=true)
    public boolean canEnterFromDirection(class_2350 var1, class_2338 var2, class_2680 var3, class_3218 var4);

    @Contract(pure=true)
    public EnumSet<class_2350> possibleExitDirections(class_2338 var1, class_2680 var2, class_1937 var3);

    @Contract(pure=true)
    default public Pair<class_2338, class_2350> exitPositionFromDirection(class_2338 pos, class_2350 dir) {
        return Pair.of((Object)pos.method_10069(dir.method_10148(), dir.method_10164(), dir.method_10165()), (Object)dir);
    }

    public class_2680 startEnergized(class_2338 var1, class_2680 var2, class_1937 var3);

    public boolean isEnergized(class_2338 var1, class_2680 var2, class_1937 var3);

    public class_2680 endEnergized(class_2338 var1, class_2680 var2, class_1937 var3);

    public static void sfx(class_2338 pos, class_2680 bs, class_1937 world, BlockEntityAbstractImpetus impetus, boolean success2) {
        class_243 vpos;
        class_243 vecOutDir;
        UUID activator = class_156.field_25140;
        if (impetus != null && impetus.getExecutionState() != null && impetus.getExecutionState().caster != null) {
            activator = impetus.getExecutionState().caster;
        }
        FrozenPigment colorizer = impetus == null || impetus.getExecutionState() == null ? new FrozenPigment(new class_1799((class_1935)HexItems.DYE_PIGMENTS.get(class_1767.field_7964)), activator) : impetus.getPigment();
        class_2248 class_22482 = bs.method_26204();
        if (class_22482 instanceof BlockCircleComponent) {
            BlockCircleComponent bcc = (BlockCircleComponent)class_22482;
            class_2350 outDir = bcc.normalDir(pos, bs, world);
            float height = bcc.particleHeight(pos, bs, world);
            vecOutDir = new class_243(outDir.method_23955());
            vpos = class_243.method_24953((class_2382)pos).method_1019(vecOutDir.method_1021((double)height));
        } else {
            vpos = class_243.method_24953((class_2382)pos);
            vecOutDir = new class_243(0.0, 0.0, 0.0);
        }
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            ParticleSpray spray = new ParticleSpray(vpos, vecOutDir.method_1021(success2 ? 1.0 : 1.5), success2 ? 0.1 : 0.5, (float)Math.PI / (float)(success2 ? 4 : 2), success2 ? 30 : 100);
            spray.sprayParticles(serverLevel, success2 ? colorizer : new FrozenPigment(new class_1799((class_1935)HexItems.DYE_PIGMENTS.get(class_1767.field_7964)), activator));
        }
        float pitch = 1.0f;
        class_3414 sound = HexSounds.SPELL_CIRCLE_FAIL;
        if (success2 && impetus != null) {
            sound = HexSounds.SPELL_CIRCLE_FIND_BLOCK;
            CircleExecutionState state = impetus.getExecutionState();
            int note = state.reachedPositions.size() - 1;
            int semitone = impetus.semitoneFromScale(note);
            pitch = (float)Math.pow(2.0, (double)(semitone - 8) / 12.0);
        }
        world.method_43128(null, vpos.field_1352, vpos.field_1351, vpos.field_1350, sound, class_3419.field_15245, 1.0f, pitch);
    }

    default public void fakeThrowMishap(class_2338 pos, class_2680 bs, CastingImage image, CircleCastEnv env, Mishap mishap) {
        Mishap.Context errorCtx = new Mishap.Context(null, (class_2561)bs.method_26204().method_9518().method_27693(" (").method_10852((class_2561)class_2561.method_43470((String)pos.method_23854())).method_27693(")"));
        OperatorSideEffect.DoMishap sideEffect = new OperatorSideEffect.DoMishap(mishap, errorCtx);
        CastingVM vm = new CastingVM(image, env);
        sideEffect.performEffect(vm);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class ControlFlow {

        public static final class Stop
        extends ControlFlow {
        }

        public static final class Continue
        extends ControlFlow {
            public final CastingImage update;
            public final List<Pair<class_2338, class_2350>> exits;

            public Continue(CastingImage update, List<Pair<class_2338, class_2350>> exits) {
                this.update = update;
                this.exits = exits;
            }
        }
    }
}

